const router = require("express").Router();
const { createNationalIdInfo, updateNationalIdInfo, getNationalIdInfo, deleteNationalIdInfo } = require("../../controllers/personRecord/nationalIdInfo.controller");
const upload = require("../../middleware/upload");
const { sendErrorResponse } = require("../../utils");


// Accept attachment_1 & attachment_2 uploads
const uploadDocumentsFields = upload.fields([
  { name: 'attachment_1', maxCount: 1 },
  { name: 'attachment_2', maxCount: 1 }
]);

router.post("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, createNationalIdInfo);

router.put("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, updateNationalIdInfo);

router.get("/", getNationalIdInfo);

router.delete("/", deleteNationalIdInfo);

module.exports = router;

