const { sendErrorResponse, sendResponse } = require("../../utils/index.js");
const { tables } = require("../../utils/tables.js");
const { performQuery } = require("../../utils/db.js");

module.exports.getTimeSheet = async (req, res) => {
  try {
    const { id, employee_id_external } = req.query;

    let query = `
      SELECT
        ts.*,
        emp.id AS employee_id,
        emp.employee_id_external,
        p.person_id_external,
        p.display_name,
        tsd.id AS time_sheet_detail_id,
        tsd.day, tsd.date AS detail_date,
        tsd.planned_time, tsd.recorded_time, tsd.recordings,
        ts.sequence_no,
        ts.created_at, ts.created_by,
        ts.updated_at, ts.updated_by,
        tpd.time_type_id_external,
        tt.external_name AS time_type_name

      FROM ${tables.time_sheet} ts
      LEFT JOIN ${tables.emp_employee} emp ON ts.employee_id_external = emp.employee_id_external AND emp.is_deleted = 2
      LEFT JOIN ${tables.per_person} p ON emp.person_id_external = p.person_id_external AND p.is_deleted = 2
      LEFT JOIN ${tables.time_sheet_detail} tsd ON ts.time_sheet_id_external = tsd.time_sheet_id_external AND tsd.is_active = 1
      LEFT JOIN ${tables.time_profile_details} tpd ON ts.time_profile_id_external = tpd.time_profile_id_external AND tpd.is_active = 1
      LEFT JOIN ${tables.time_type} tt ON tpd.time_type_id_external = tt.time_type_id_external AND tt.is_active = 1
      WHERE ts.is_active = 1
    `;

    if (id) {
      query += ` AND ts.id = ${id}`;
    }

    if (employee_id_external) {
      query += ` AND ts.employee_id_external = '${employee_id_external}'`;
    }

    query += ` ORDER BY ts.id DESC`;

    const result = await performQuery(query);
    const transformedResult = transformTimeSheetData(result);

    return sendResponse(res,transformedResult,"Time Sheet fetched successfully",200);

  } catch (error) {
    return sendErrorResponse(res, error, "Error while fetching Time Sheet");
  }
};

const day = [
  "Sunday",
  "Monday",
  "Tuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday"
]


const transformTimeSheetData = (data) => {
  const map = new Map();
  data.forEach((row) => {
    const key = row.id;
    if (!map.has(key)) {
      map.set(key, {
        id: row.id,
        sequence_no: row.sequence_no,
        time_sheet_id_external: row.time_sheet_id_external,
        external_name: row.external_name,
        date_from: row.date_from,
        date_to: row.date_to,
        employee_id_external: row.employee_id_external,
        employee_name: row.display_name,
        time_profile_id_external: row.time_profile_id_external,
        schedule_id_external: row.schedule_id_external,
        planned_working_time: row.planned_working_time,
        recorded_working_time: row.recorded_working_time,
        approval_status: row.approval_status,
        approval_remarks: row.approval_remarks,
        approver_id_external: row.approver_id_external,
        created_at: row.created_at,
        created_by: row.created_by,
        updated_at: row.updated_at,
        updated_by: row.updated_by,
        available_time_types: [],
        time_sheet_detail: [],
      });
    }

    const agg = map.get(key);
    if (row.time_sheet_detail_id) {
      const alreadyExists = agg.time_sheet_detail.some(
        (d) => d.id === row.time_sheet_detail_id
      );

      if (!alreadyExists) {
        agg.time_sheet_detail.push({
          id: row.time_sheet_detail_id,
          day: row.day,
          day_name: day[row.day],
          date: row.detail_date,
          planned_time: row.planned_time,
          recorded_time: row.recorded_time,
          recordings: row.recordings,
        });
      }
    }
    if (row.time_type_id_external) {
      const timeTypeExists = agg.available_time_types.some(
        (tt) => tt.time_type_id_external === row.time_type_id_external
      );
      if (!timeTypeExists) {
        agg.available_time_types.push({
          time_type_id_external: row.time_type_id_external,
          time_type_name: row.time_type_name,
        });
      }
    }
  });

  return Array.from(map.values());
};
