const {createPosition, getPostion, updatePosition} = require("../../controllers/organizationRecord/position.controller");

const router = require("express").Router();
const upload = require("../../middleware/upload");
const { sendErrorResponse } = require("../../utils");


// Accept cust_attachment
const uploadDocumentsFields = upload.fields([
  { name: 'cust_attachment', maxCount: 1 }
]);


router.post("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, createPosition);

router.get("/", getPostion);

router.put("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, updatePosition);

module.exports = router;
