const moment = require("moment-timezone");
const { performQuery } = require("../utils/dbFunctions");
const { getSystemTime, getTimezone } = require("../functions/serverTime");

const getDayTime = async (shift) => {
  const currentDate = await getSystemTime(); // Get today's date using moment
  const timezone = await getTimezone(); // Replace with your desired timezone

  // Queries to get earliest time in start Time and End Time
  const startTimeQuery = `SELECT * FROM Shift ORDER BY TIME(STR_TO_DATE(startTime, '%H:%i:%s')) ASC`;
  const endTimeQuery = `SELECT * FROM Shift ORDER BY TIME(STR_TO_DATE(endTime, '%H:%i:%s')) ASC`;

  // Extract Time value from Data
  const startTime = (await performQuery(startTimeQuery))?.[0].startTime;
  const endTime = (await performQuery(endTimeQuery))?.[0].endTime;

  // Parse the start and end times
  let startDateTime = moment.tz(
    `${currentDate.format("YYYY-MM-DD")} ${startTime}`,
    timezone
  );
  let endDateTime = moment.tz(
    `${currentDate.format("YYYY-MM-DD")} ${endTime}`,
    timezone
  );

  // If the end time is earlier than the start time, add 1 day to the endDateTime
  if (endDateTime.isSameOrBefore(startDateTime)) {
    endDateTime.add(1, "day");
  }

  // Format the dates into "MM/DD/YYYY HH:mm:ss"
  const formattedStart = startDateTime.format("MM/DD/YYYY HH:mm:ss");
  const formattedEnd = endDateTime.format("MM/DD/YYYY HH:mm:ss");

  return {
    Date: currentDate.format("YYYY-MM-DD"),
    start: formattedStart,
    end: formattedEnd,
  };
};
module.exports = {
  getDayTime,
};
