const { getSystemTime } = require("../functions/getTimezone");
const { logger } = require("../helper/logger.helper");
const moment = require("moment-timezone");
const { performQuery } = require("../utils/db");
const { tables } = require("../utils/tables");


module.exports.createTimeEventCronJob = async () => {
    try {
        const systemtime = await getSystemTime();
        const currenttime = moment(systemtime).format("YYYY-MM-DD HH:mm:ss")
        const date = moment(systemtime).format("YYYY-MM-DD");

        // get Attendance Data for current Data and where employee id external is not null
        let attendanceData = await performQuery(`
            SELECT ad.id, ad.unique_value, au.employee_id_external, ad.date, ad.clock_in, ad.clock_out, te_ci.time_event_id_external AS clockin_event, te_co.time_event_id_external AS timeout_event
            FROM ${tables.attendance_user} au
            LEFT JOIN ${tables.attendance_data} ad ON ad.employee_id = au.id and ad.date = '${date}' 
            LEFT JOIN ${tables.time_event} te_ci ON te_ci.attendance_data_unique_value = ad.unique_value AND te_ci.time_event_type = 103 AND te_ci.is_active = 1
            LEFT JOIN ${tables.time_event} te_co ON te_co.attendance_data_unique_value = ad.unique_value AND te_co.time_event_type = 104 AND te_co.is_active = 1
            where au.employee_id_external IS NOT NULL
        `);     
        let clockInEventsInsertQuery = `
            INSERT INTO ${tables.time_event} (
                time_event_id_external, date, attendance_data_unique_value, 
                employee_id_external, time_value, time_event_type, approval_status, 
                approval_timestamp, created_at, updated_at
            )  Values `;
        let clockOutEventsInsertQuery = `
            INSERT INTO ${tables.time_event} (
                time_event_id_external, date, attendance_data_unique_value, 
                employee_id_external, time_value, time_event_type, approval_status, 
                approval_timestamp, created_at, updated_at
            )  Values `;

        attendanceData.map(ad => {
            if (ad.clock_in !== 'N/A' && !ad.clockin_event) {
                const time_event_id_external = `${ad.employee_id_external}-${date}-IN`
                clockInEventsInsertQuery += `(
                    '${time_event_id_external}', '${date}', '${ad.unique_value}', 
                    '${ad.employee_id_external}', '${ad.clock_in}', 103, 1, 
                    '${currenttime}', '${currenttime}', '${currenttime}'),`
            }
            if (ad.clock_out !== 'N/A' && !ad.clockout_event) {
                const time_event_id_external = `${ad.employee_id_external}-${date}-OUT`
                clockOutEventsInsertQuery += `(
                    '${time_event_id_external}', '${date}', '${ad.unique_value}', 
                    '${ad.employee_id_external}', '${ad.clock_out}', 104, 1, 
                    '${currenttime}', '${currenttime}', '${currenttime}'),`
            }

        });
        if(clockInEventsInsertQuery.slice(0, -1).length > 310) {
            const insertClockInEvents = await performQuery(clockInEventsInsertQuery.slice(0, -1) + ";");
            console.log("insertClockInEvents ", insertClockInEvents);
        }
        console.log(clockOutEventsInsertQuery.slice(0, -1).length);
        
        if(clockOutEventsInsertQuery.slice(0, -1).length > 310) {
            const insertClockOutEvents = await performQuery(clockOutEventsInsertQuery.slice(0, -1) + ";");
            console.log("insertClockOutEvents ", insertClockOutEvents);
        }
    } catch (error) {
        console.log("Error in Create Time Event Cron Job: ", error);
        logger.error("Error in Create Time Event Cron Job: ", error);
    }
}


