const router = require("express").Router();
const { addEducationalDocuments, updateEducationalDocuments, getEducationalDocuments, deleteEducationalDocuments } = require("../../controllers/personRecord/educationalDetails.controller");
const upload = require("../../middleware/upload");
const { sendErrorResponse } = require("../../utils");

// Accept attachment_1 & attachment_2 uploads
const uploadDocumentsFields = upload.fields([
  { name: 'attachment_1', maxCount: 1 },
  { name: 'attachment_2', maxCount: 1 }
]);


// API to Add Educational Documents --> POST /api/personRecord/educational-details
router.post("/", (req, res, next) => {
    uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
});
}, addEducationalDocuments);


// API to Update Educational Documents --> PUT /api/personRecord/educational-details
router.put("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, updateEducationalDocuments);

// API to Get Educational Documents --> GET /api/personRecord/educational-details
router.get("/", getEducationalDocuments)

// API to Delete Educational Documents --> DELETE /api/personRecord/educational-details
router.delete("/", deleteEducationalDocuments);


module.exports = router;
