const express = require("express");
const mysql = require("mysql2");
const colors = require("colors");
const morgan = require("morgan");
const helmet = require("helmet");
const dotenv = require("dotenv");
const path = require("path");
const cors = require("cors");

const api = require("./routes/router");
const { authMiddleware } = require("./middleware/authMiddleware");


//===> configure dotenv
dotenv.config();

//===> rest object
const app = express();

//===> middleware
app.use(express.json());
app.use(morgan("dev"));
app.use(
  cors()
);

//===> Helmet for security

app.use(
  helmet({
    contentSecurityPolicy: {
      useDefaults: true,
      directives: {
        // Base policy
        "default-src": [
            "'self'",
          "http://localhost:5173",
          "http://localhost:5174",
          "http://localhost:5175",
        ],

        // XHR / fetch 
        "connect-src": [
          "'self'",
          "https://trisync.oee-tracker.com",
          "http://trisync.oee-tracker.com",
          "http://localhost:5173",
          "http://localhost:5174",
          "http://localhost:5175",
        ],
        
         "script-src": [
          "'self'",
          "https://unpkg.com",
        ],

        // Images 
        "img-src": [
          "'self'",
          "data:",
          "blob:",
          "https://trisync.oee-tracker.com",
          "http://trisync.oee-tracker.com",
          "http://localhost:5173",
          "http://localhost:5174",
          "http://localhost:5175",
        ],

        // For embedding viewers in iframe  blob
        "frame-src": [
          "'self'",
          "blob:",
          "https://trisync.oee-tracker.com",
          "http://trisync.oee-tracker.com",
          "http://localhost:5173",
          "http://localhost:5174",
          "http://localhost:5175",
        ],
        // For Older Browser
        "child-src": [
          "'self'",
          "blob:",
          "https://trisync.oee-tracker.com",
          "http://trisync.oee-tracker.com",
          "http://localhost:5173",
          "http://localhost:5174",
          "http://localhost:5175",
        ],

        // For pdf.js / web workers
        "worker-src": [
          "'self'",
          "blob:",
        ],
      },
    },
    crossOriginResourcePolicy: { policy: "cross-origin" },
  })
);

//===> Reverse proxy
 app.set("trust proxy", true);



// Not For All Origin 
// app.use(helmet({
//   contentSecurityPolicy: {
//     useDefaults: true,
//     directives: {
//       "img-src": ["'self'", "data:", "blob:", "https://trisync.oee-tracker.com"],
//     },
//   },
//   crossOriginResourcePolicy: { policy: "cross-origin" },
// }));


//===> routes
// app.get("/", (req, res) => {
//   res.status(200).send("<h2>Hello From backend</h2>");
//   console.log("GET /".green);
// });

// app.use("/uploads", express.static("uploads"));
app.use("/uploads", express.static(path.join(__dirname, "uploads")));
app.use("/uploads/images", express.static("uploads/images"));

//===> API routes
app.use("/api", api);


app.use(
  "/",
  express.static(path.resolve(path.join(__dirname, "./client/dist")))
);

app.use(
  "*",
  express.static(path.resolve(path.join(__dirname, "./client/dist")))
);

//===> PORT
const PORT = process.env.PORT || 5001;

//===> listen
app.listen(PORT, () => {
  console.log(
    `Server is running on: http://localhost:${PORT}`.bgCyan.green.bold
  );
});
