const { createPersonalInfoRecord, updatePersonalInfoRecord, getPersonalInfoRecord, deletePersonalInfoRecord } = require("../../controllers/personRecord/personalInfo.controller");

const router = require("express").Router();
const upload = require("../../middleware/upload");
const { sendErrorResponse } = require("../../utils");


// Accept attachment_1 & attachment_2 uploads
const uploadDocumentsFields = upload.fields([
  { name: 'attachment_1', maxCount: 1 },
  { name: 'attachment_2', maxCount: 1 }
]);

router.post("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, createPersonalInfoRecord);

router.put("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, updatePersonalInfoRecord);

router.get("/", getPersonalInfoRecord);

router.delete("/", deletePersonalInfoRecord);

module.exports = router;