const router = require("express").Router();

const legalEntityRoutes = require("./organizationRecord/legalentity.route");
const businessUnitRoutes = require("./organizationRecord/businessunit.route");
const divisionRoutes = require("./organizationRecord/division.route");
const departmentRoutes = require("./organizationRecord/department.route");
const sectionRoutes = require("./organizationRecord/section.route");
const unitRoutes = require("./organizationRecord/unit.route");
const costcenterRoutes = require("./organizationRecord/costcenter.route");
const gradeRoutes = require("./organizationRecord/grade.route");
const jobclassificationRoutes = require("./organizationRecord/jobclassification.route");
const locationRoutes = require("./organizationRecord/location.route");
const locationgroupRoutes = require("./organizationRecord/locationgroup.route");
const paygroupRoutes = require("./organizationRecord/paygroup.route");
const recurringpaycompRoutes = require("./organizationRecord/recurringpaycomp.route");
const nonrecurringpaycompRoutes = require("./organizationRecord/nonrecurringpaycomp.route");
const compensationRoutes = require("./organizationRecord/compansation.route");
const positionRoutes = require("./organizationRecord/position.route");

//===> Legal Entity
router.use("/legal-entity", legalEntityRoutes);

//===> Business Unit
router.use("/business-unit", businessUnitRoutes);

//===> Division
router.use("/division",  divisionRoutes);

//===> Department
router.use("/department",  departmentRoutes);

//===> Section
router.use("/section",  sectionRoutes);

//===> Unit
router.use("/unit",  unitRoutes);

//===> Cost Center
router.use("/cost-center",  costcenterRoutes);

//===> Grade
router.use("/grade",  gradeRoutes);

//===> Job Classification
router.use("/job-classification", jobclassificationRoutes);

//===> Location
router.use("/location",  locationRoutes);

//===> Location Group
router.use("/location-group", locationgroupRoutes); 

//===> Pay Group
router.use("/pay-group",  paygroupRoutes);

//===> Recurring Pay Component
router.use("/recurring-paycomp", recurringpaycompRoutes);

//===> Non Recurring Pay Component
router.use("/nonrecurring-paycomp", nonrecurringpaycompRoutes); 

//===> Compensation
router.use("/compensation", compensationRoutes);

// ===> Position
router.use("/position",  positionRoutes);

module.exports = router;
