const router = require("express").Router();

const personalInfoRoute = require("./personRecord/personalInfo.route");
const nationalIdInfoRoute = require("./personRecord/nationalIdInfo.route");
const drivingLicenseRoute = require("./personRecord/drivinglinces.route");
const visaIqamaRoute = require("./personRecord/visaiqama.route");
const passportRoute = require("./personRecord/passport.route");
const emailRoute = require("./personRecord/email.route");
const dependantRoute = require("./personRecord/dependant.route");
const educationalDetailsRoute = require("./personRecord/educationalDetails.route");
const paymentDetailsRoute = require("./personRecord/paymentDetails.route");
const addressRoutes = require("./personRecord/address.route");
const contactRoutes = require("./personRecord/contactno.route");
const emergencyContactRoutes = require("./personRecord/emergencycontact.route");
const gosiRoutes = require("./personRecord/specificdataforgosi.route");

//===> National ID Info
router.use("/national-id", nationalIdInfoRoute);

//===> Personal Info
router.use("/personal-info", personalInfoRoute);

//===> Driving License
router.use("/driving-license", drivingLicenseRoute);

//===> Visa/Iqama
router.use("/visa-iqama", visaIqamaRoute);

//===> Passport
router.use("/passport", passportRoute);

//===> Email
router.use("/email", emailRoute);

//===> Dependant
router.use("/dependant", dependantRoute);

//===> Educational Details
router.use("/educational-details", educationalDetailsRoute);

//===> Payment Details
router.use("/payment-details", paymentDetailsRoute);

//===> Address Details
router.use("/address", addressRoutes);

//===> Contact No
router.use("/contact", contactRoutes);

//===> Emergency Contact No
router.use("/emergency-contact", emergencyContactRoutes);

//===> Specific Data for GOSI
router.use("/specific-data-for-gosi", gosiRoutes);

module.exports = router;
