const {createTermination , getTermination , updateTermination} = require("../../controllers/employeeRecord/termination.controller");

const router = require("express").Router();
const upload = require("../../middleware/upload");
const { sendErrorResponse } = require("../../utils");


// Accept attachment_1 & attachment_2 uploads
const uploadDocumentsFields = upload.fields([
  { name: 'resignation_doc', maxCount: 1 },
  { name: 'termination_doc', maxCount: 1 }
]);


router.post("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, createTermination);

router.get("/", getTermination);

router.put("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, updateTermination);


module.exports = router;
