const pool = require("../../utils/db");
const RESPONSE = require("../response/RESPONSE");

exports.SELECT = (payload, res) => {
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        res.status(500).send(RESPONSE("database error", {}));
        throw err;
      }
      connection.query(
        `SELECT * FROM ${payload.tableName} ORDER BY id ${payload.orderBy}`,
        (err, result) => {
          connection.release();
          if (err) {
            return res.status(400).send(RESPONSE("error while select", {}));
          } else {
            return res.status(200).send(RESPONSE("Succesfully select", result));
          }
        }
      );
    });
  } catch (err) {
    return res.status(500).send(RESPONSE(err.message, err));
  }
};

exports.SELECTWithWhereClause = (payload, res) => {
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        res.status(500).send(RESPONSE("database error", {}));
        throw err;
      }
      connection.query(
        `SELECT ${payload.select} FROM ${payload.tableName} where ${payload.key}="${payload.value}" ORDER BY id ${payload.orderBy}`,
        (err, result) => {
          connection.release();
          if (err) {
            return res.status(400).send(RESPONSE("error while select", {}));
          } else {
            return res.status(200).send(RESPONSE("Succesfully select", result));
          }
        }
      );
    });
  } catch (err) {
    return res.status(500).send(RESPONSE(err.message, err));
  }
};

exports.SELECTWithWhereCondition = (payload, res) => {
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        res.status(500).send(RESPONSE("database error", {}));
        throw err;
      }
      connection.query(
        `SELECT ${payload.select} FROM ${payload.tableName} where ${payload.key}="${payload.value}"`,
        (err, result) => {
          connection.release();
          if (err) {
            return res.status(400).send(RESPONSE("error while select", {}));
          } else {
            return res.status(200).send(RESPONSE("Succesfully select", result));
          }
        }
      );
    });
  } catch (err) {
    return res.status(500).send(RESPONSE(err.message, err));
  }
};
exports.SELECTWithWhereId = (payload, res) => {
  console.log("payload >>>", payload);
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        res.status(500).send(RESPONSE("database error", {}));
        throw err;
      }
      connection.query(
        `SELECT * FROM ${payload.tableName} where id=${payload.value}`,
        (err, result) => {
          connection.release();
          if (err) {
            return res.status(400).send(RESPONSE("error while select", {}));
          } else {
            return res.status(200).send(RESPONSE("Succesfully select", result));
          }
        }
      );
    });
  } catch (err) {
    return res.status(500).send(RESPONSE(err.message, err));
  }
};

exports.SELECTWithWhereUserId = (payload, res) => {
  console.log("payload >>>", payload);
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        res.status(500).send(RESPONSE("database error", {}));
        throw err;
      }
      connection.query(
        `SELECT * FROM ${payload.tableName} where userId=${payload.value}`,
        (err, result) => {
          connection.release();
          if (err) {
            return res.status(400).send(RESPONSE("error while select", {}));
          } else {
            return res.status(200).send(RESPONSE("Succesfully select", result));
          }
        }
      );
    });
  } catch (err) {
    return res.status(500).send(RESPONSE(err.message, err));
  }
};
