const mysql = require('mysql2');
const { DB_HOST, DB_USER, DB_PASSWORD, DB_NAME } = require('../config/index.js');

const pool = mysql.createPool({
  host: DB_HOST,
  user: DB_USER,
  password: DB_PASSWORD,
  database: DB_NAME,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
  enableKeepAlive: true,
  keepAliveInitialDelay: 10000,
});

function getConnection() {
  return new Promise((resolve, reject) => {
    pool.getConnection((err, connection) => (
      err ? reject(err) : resolve(connection)));
  });
}

async function performQuery(sql, params) {
  let connection;
  try {
    connection = await getConnection();

    // IMPORTANT: await the query promise before finally{} runs
    const results = await new Promise((resolve, reject) => {
      connection.query(sql, params, (error, results) => {
        if (error) return reject(error);
        resolve(results);
      });
    });

    return results;
  } catch (error) {
    console.error('Query/Connection error:', error);
    throw error;
  } finally {
    if (connection) {
      connection.release();
      console.log('Connection released');
    }
  }
}

module.exports = { pool, getConnection, performQuery };