const { signUpApplicant, verifyEmail, loginApplicant, loginVerifyApplicant, forgotPasswordApplicant, resetPasswordApplicant, setNewPassword} = require("../controllers/auth.controller");

const router = require("express").Router();

router.post("/signup", signUpApplicant);        // Api For Applicant Sign Up
router.post("/signup/verify", verifyEmail);     // Api For Applicant Email Verification
router.post("/login", loginApplicant);          // Api For Applicant/ Employee Login
router.post("/login/verify", loginVerifyApplicant);         // API for 2FA Login Verification
router.post("/forgot-password", forgotPasswordApplicant);   // API for Forgot Password
router.post("/reset-password", resetPasswordApplicant);     // API for Reset Password
router.post("/set-password", setNewPassword); // API for Set New Password

module.exports = router;
