const {createTimeTypeRequest , getTimeTypeRequest , updateTimeTypeRequestGeneral, updateTimeTypeRequestApprover} = require("../../controllers/attendanceRecord/timeTypeRequest.controller");

const router = require("express").Router();
const upload = require("../../middleware/upload");
const { sendErrorResponse } = require("../../utils");


// Accept attachment_path
const uploadDocumentsFields = upload.fields([
  { name: 'attachment_path', maxCount: 1 }
]);


router.post("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, createTimeTypeRequest);

router.get("/", getTimeTypeRequest);

router.put("/approval", updateTimeTypeRequestApprover);

router.put("/", (req, res, next) => {
  uploadDocumentsFields(req, res, (err) => {
    if (err) {
        return sendErrorResponse(res, err, "Error while uploading files: "+ err.message );
    }
    next();
  });
}, updateTimeTypeRequestGeneral);
module.exports = router;
