const router = require("express").Router();

const attendanceUserRoute = require("./attendanceRecord/attendanceUser.route");
const attendanceDataRoute = require("./attendanceRecord/attendanceData.route")
const holidayCalendarRoute = require("./attendanceRecord/holidayCalendar.route")
const holidaysRoute = require("./attendanceRecord/holidays.route")
const holidayAssignmentsRoute = require("./attendanceRecord/holidayAssignments.route")
const workScheduleRoute = require("./attendanceRecord/workSchedule.route")
const workSchedulDetailseRoute = require("./attendanceRecord/workScheduleDetails.route")
const dayModelRoute = require("./attendanceRecord/dayModel.route")
const dayModelSegmentsRoute = require("./attendanceRecord/dayModelSegments.route")
const timeTypeRoute = require("./attendanceRecord/timeType.route")
const timeProfileRoute = require("./attendanceRecord/timeProfile.route")
const timeProfileDetailsRoute = require("./attendanceRecord/timeProfileDetails.route")
const timeTypeRequestRoute = require("./attendanceRecord/timeTypeRequest.route");



// ===> Attendance User
router.use("/attendance-user", attendanceUserRoute);
router.use("/attendance-data", attendanceDataRoute)
router.use("/holiday-calendar", holidayCalendarRoute)
router.use("/holiday", holidaysRoute)
router.use("/holiday-assignment", holidayAssignmentsRoute)
router.use("/work-schedule", workScheduleRoute)
router.use("/work-schedule-detail", workSchedulDetailseRoute)
router.use("/day-model", dayModelRoute)
router.use("/day-model-segments", dayModelSegmentsRoute)
router.use("/time-type", timeTypeRoute)
router.use("/time-profile", timeProfileRoute)
router.use("/time-profile-details", timeProfileDetailsRoute)
router.use("/time-type-request", timeTypeRequestRoute);

module.exports = router;
