const winston = require("winston");
const moment = require("moment-timezone");

const logger = winston.createLogger({


  level: "info", // Set the minimum log level (e.g., 'debug', 'warn', 'error')
  format: winston.format.combine(
    winston.format.timestamp({ format: "YYYY-MM-DD HH:mm:ss" }),
    winston.format.json()
  ),
  transports: [
    // Local File Transport (for errors)
    new winston.transports.File({ filename: `logs/error-${moment().format("YYYY-MM-DD")}.log`, level: "error" }),
    // Local File Transport (for development)
    new winston.transports.File({ filename: `logs/dev-${moment().format("YYYY-MM-DD")}.log`, level: "debug" }),
    // Production Transport (configure accordingly)
    new winston.transports.File({
      filename: `logs/production-${moment().format("YYYY-MM-DD")}.log`,
      level: "info",
    }),
  ],
});

const errorHandler = (err, req, res, next) => {
  console.error("Error caught in global error handler:", err.message);
  const { method, url } = req;

  console.error(err.stack);
  logger.error(`Request: ${method} ${url}`, {
    errorMessage: err.message,
    errorStack: err.stack,
    error: err,
  });
  logger.info(`Request: ${method} ${url}`, {
    errorMessage: err.message,
    errorStack: err.stack,
    error: err,
  });
  next(err);
};

module.exports = { logger, errorHandler };
