const { sendErrorResponse, sendResponse, } = require("../../utils/index.js");
const { tables } = require("../../utils/tables.js");
const { performQuery } = require("../../utils/db.js");
const moment = require("moment-timezone");
const { getTimezone, getSystemTime } = require("../../functions/getTimezone.js");
const fs = require('fs');
const path = require('path');

// READ User Attendance
module.exports.getAttendanceUser = async (req, res) => {
  try {
    const { id } = req.query;

    let query = `
      SELECT * 
      FROM ${tables.attendance_user}
      WHERE 1
    `;

    if (id) query += ` AND id = ${id}`;
    query += ` ORDER BY id DESC`;

    const result = await performQuery(query);
    return sendResponse(res, result, "User fetched successfully", 200);
  } catch (error) {
    console.error("Error While Fetching User:", error);
    return sendErrorResponse(res, error, "Error while fetching User:");
  }
};

module.exports.updateAttendanceUser = async (req, res) => {
  try {
    const {
      id,
      name,
      employee_id_external
    } = req.body;

    // Required Validation
    if (!id || !name) {
      const errorMessage = "ID and Name are required";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }
    
    // Get existing record using ID + Name
    const existingRecord = await performQuery(
      `SELECT * FROM ${tables.attendance_user} WHERE id = ? AND name = ?`,
      [id, name]
    );

    if (existingRecord.length === 0) {
      return sendErrorResponse(res, "User record not found", "User record not found");
    }

    // Time
    const systemTime = await getSystemTime();
    const currentTime = moment(systemTime).format("YYYY-MM-DD HH:mm:ss");

    // --- UPDATE ONLY employee_id_external ---
    await performQuery(
      `UPDATE ${tables.attendance_user} 
       SET employee_id_external = ?, updated_at = ?, updated_by = ?
       WHERE id = ? AND name = ?`,
      [
        employee_id_external,
        currentTime,
        req?.user?.id,
        id,
        name
      ]
    );

    return sendResponse(res, {}, "User updated successfully", 200);

  } catch (error) {
    console.log("Error While Updating User:", error);
    return sendErrorResponse(res, error, "Error while updating User");
  }
};
